﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

//AudioGroup is a linked group of AudioFiles - useful for picking a random file from a group
public class AudioGroup
{
    public string ID { get; private set; }
    public Dictionary<string, AudioFile> Files { get; private set; } = new Dictionary<string, AudioFile>();

    public AudioGroup(string id, Dictionary<string, AudioFile> files)
    {
        ID = id;
        Files = files;
    }

    /// <summary>
    /// Returns a random AudioFile from the group
    /// </summary>
    /// <returns>A random AudioFile from the group</returns>
    public AudioFile GetRandomFile()
    {
        Randomizer.Regenerate();
        int index = Randomizer.RNG.Next(0, Files.Count);
        return Files.Values.ElementAt(index);
    }
}
